package eqsolver.tests;

import java.awt.*;

import javax.swing.*;

import eqsolver.*;
import eqsolver.ui.EquationMenu;
import eqsolver.ui.EquationPanel;
import eqsolver.ui.ParametersPanel;
import eqsolver.ui.SolutionPanel;

public class Test1 {
	public static void main(String[] args) {
		
		
		float[] param = {0,0,0,0,0};
		
		IEquation equation = new Equation(2, param);
		ProxyEquation realequation = new ProxyEquation(equation);
		realequation.setEquation(2, param);
		realequation.update();
		
		System.out.println("\n");
//		System.out.println(defaultParam.length);
//		
//		for (int i = 0; i < realequation.getSol().length; i++) {
//			System.out.println(realequation.getSol()[i]);		
//		}
//				
		

		
		
		
		
		
		
		JFrame frame = new JFrame();
		frame.setTitle("test1");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(600, 300);
		
		
		
		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		
		
		//l'ordine delle istanze va tenuto così perché altrimenti ci saranno un sacco di eccezioni
		JPanel parampanel = new ParametersPanel(realequation);
		
		JMenuBar menubar = new JMenuBar();
		menubar.add(new EquationMenu(realequation));	
			
		frame.setJMenuBar(menubar);
		
		
		JPanel eqpanel = new EquationPanel(realequation);
		JPanel solpanel = new SolutionPanel(realequation);
		
		
		
		
		
		panel.setLayout(new GridLayout(1, 3));
		panel.add(eqpanel);
		panel.add(parampanel, BorderLayout.CENTER);
		panel.add(solpanel);
		
		
		
		frame.setVisible(true);
		//serve per mettere la schermata al centro
		Dimension dim=
				Toolkit.getDefaultToolkit().getScreenSize();
				frame.setLocation((int)(dim.getWidth()-frame.getWidth())/2,(int)(dim.getHeight()-frame.getHeight())/2);
	}
	
	
}
